# keyboards.py
from telegram import InlineKeyboardButton, InlineKeyboardMarkup, ReplyKeyboardMarkup, KeyboardButton

# --- کیبوردهای عمومی و کمکی ---

def get_confirm_keyboard(prefix: str):
    """کیبورد تأیید/لغو برای مراحل مختلف ادمین"""
    keyboard = [
        [InlineKeyboardButton("✅ تأیید و ادامه", callback_data=f'{prefix}_yes')],
        [InlineKeyboardButton("❌ لغو", callback_data=f'{prefix}_no')]
    ]
    return InlineKeyboardMarkup(keyboard)

# --- کیبوردهای ادمین ---

def get_admin_main_keyboard():
    """کیبورد اینلاین برای منوی اصلی ادمین"""
    keyboard = [
        [InlineKeyboardButton("➕ افزودن محصول", callback_data='admin_add_product_start')],
        [InlineKeyboardButton("📦 مدیریت محصولات", callback_data='admin_products')],
        [InlineKeyboardButton("🏠 منوی اصلی کاربر", callback_data='start_user')]
    ]
    return InlineKeyboardMarkup(keyboard)

def get_admin_products_keyboard():
    """کیبورد اینلاین برای مدیریت محصولات"""
    keyboard = [
        [InlineKeyboardButton("➕ افزودن محصول جدید", callback_data='admin_add_product_start')],
        [InlineKeyboardButton("🔙 بازگشت به پنل ادمین", callback_data='start_admin')],
    ]
    return InlineKeyboardMarkup(keyboard)


def get_admin_shipping_keyboard(order_id: int, action: str):
    """کیبورد تعیین هزینه ارسال برای ادمین"""
    keyboard = [
        [InlineKeyboardButton("💵 تعیین هزینه ارسال", callback_data=f'shipping_set_{order_id}')],
        [InlineKeyboardButton("❌ لغو سفارش", callback_data=f'shipping_cancel_order_{order_id}')]
    ]
    return InlineKeyboardMarkup(keyboard)

def get_admin_receipt_keyboard(order_id: int):
    """کیبورد تأیید نهایی رسید برای ادمین"""
    keyboard = [
        [InlineKeyboardButton("✅ تأیید واریز و ارسال", callback_data=f'receipt_confirm_accept_{order_id}')],
        [InlineKeyboardButton("❌ رد رسید", callback_data=f'receipt_confirm_reject_{order_id}')]
    ]
    return InlineKeyboardMarkup(keyboard)


# --- کیبوردهای کاربر ---

def get_user_main_keyboard():
    """کیبورد منوی اصلی کاربر"""
    keyboard = [
        [InlineKeyboardButton("🛒 سبد خرید من", callback_data='show_cart')], 
        [InlineKeyboardButton("☎️ تماس با ما / شبکه‌های اجتماعی", callback_data='social_media')],
        [InlineKeyboardButton("❓ سؤالات متداول (FAQ)", callback_data='faq')]
    ]
    return InlineKeyboardMarkup(keyboard)

def get_cart_keyboard(cart: dict):
    """کیبورد سبد خرید (فقط شامل دکمه نهایی کردن و ادامه خرید)"""
    keyboard = []
    
    # دکمه نهایی کردن خرید
    keyboard.append([InlineKeyboardButton("تأیید و نهایی کردن خرید ➡️", callback_data='confirm_checkout')])
    
    # دکمه ادامه خرید
    keyboard.append([InlineKeyboardButton("🔙 ادامه خرید", callback_data='start_user')])
    
    return InlineKeyboardMarkup(keyboard)

def get_user_payment_keyboard():
    """کیبورد پرداخت نهایی برای کاربر"""
    keyboard = [
        [InlineKeyboardButton("💳 ارسال رسید پرداخت", callback_data='send_receipt_start')],
        [InlineKeyboardButton("اطلاعات کارت بانکی", callback_data='bank_info_display')], 
        [InlineKeyboardButton("❌ لغو سفارش", callback_data='ignore')]
    ]
    return InlineKeyboardMarkup(keyboard)