# database.py
import sqlite3
import json
from config import DB_NAME

def get_db_connection():
    """ایجاد اتصال به دیتابیس و تنظیم برای دریافت نتایج با نام ستون"""
    conn = sqlite3.connect(DB_NAME)
    conn.row_factory = sqlite3.Row
    return conn

def setup_db():
    """ایجاد جداول مورد نیاز در صورت عدم وجود"""
    conn = get_db_connection()
    cursor = conn.cursor()

    # جدول کاربران
    cursor.execute("""
        CREATE TABLE IF NOT EXISTS users (
            id INTEGER PRIMARY KEY,
            username TEXT,
            first_name TEXT,
            last_name TEXT
        )
    """)

    # جدول محصولات
    cursor.execute("""
        CREATE TABLE IF NOT EXISTS products (
            product_id TEXT PRIMARY KEY, 
            name TEXT,
            price INTEGER,
            inventory INTEGER,
            random_color BOOLEAN,
            description TEXT,
            telegram_message_id INTEGER, 
            images TEXT 
        )
    """)

    # جدول سفارشات
    cursor.execute("""
        CREATE TABLE IF NOT EXISTS orders (
            order_id INTEGER PRIMARY KEY AUTOINCREMENT,
            user_id INTEGER,
            status TEXT, -- pending_cart, waiting_info, waiting_shipping_fee, waiting_payment, paid, approved, rejected
            products_json TEXT, 
            user_info_json TEXT, 
            shipping_cost INTEGER DEFAULT 0,
            payment_receipt TEXT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )
    """)

    conn.commit()
    conn.close()
    
def save_user(user_id, username, first_name):
    """ثبت یا به‌روزرسانی کاربر"""
    conn = get_db_connection()
    conn.execute("""
        INSERT OR REPLACE INTO users (id, username, first_name) VALUES (?, ?, ?)
    """, (user_id, username, first_name))
    conn.commit()
    conn.close()

def save_product(product_data):
    """ذخیره محصول جدید"""
    conn = get_db_connection()
    conn.execute("""
        INSERT INTO products (product_id, name, price, inventory, random_color, description, images)
        VALUES (?, ?, ?, ?, ?, ?, ?)
    """, (
        product_data['product_id'], 
        product_data['name'], 
        product_data['price'], 
        product_data['inventory'], 
        1 if product_data['random_color'] else 0,  # تبدیل بولی به عدد
        product_data['description'], 
        product_data['images']
    ))
    conn.commit()
    conn.close()
    
def get_product(product_id):
    """دریافت اطلاعات یک محصول"""
    conn = get_db_connection()
    product = conn.execute("SELECT * FROM products WHERE product_id = ?", (product_id,)).fetchone()
    conn.close()
    return product